
//Chris' WinGlide enhancements
//Copr. 1998, Chris Dohnal (cwdohnal@ucdavis.edu)

#include <windows.h>
#include <glide.h>
#include <ddraw.h>
#include "pointers.h"
#include "pcopy.h"
#include "main.h"
#include "dxdraw.h"
#include "errcode.h"
#include "msgbox.h"
#include "gamma.h"
#include "inifile.h"
#include "b2wg.h"
#include "sbwg.h"
#include "ovlwg.h"
#include "osswg.h"
#include "gammadlg.h"

BOOL CWGInitialize(HWND, DWORD, DWORD);
VOID CWGShutdown(VOID);
VOID CWGCopy3DfxFrameBuffer(VOID);
FxBool CWGControl(FxU32);


BOOL CWGInitialize(HWND hWnd, DWORD dwWidth, DWORD dwHeight) {
	BOOL bRet;

	//Load preferences from the ini file
	LoadINIFile();

	//See which mode WinGlide is in
	switch (gdwWinGlideMode) {
	case WINGLIDE_MODE_OFF_SCREEN_SURFACE:
		bRet = OssWGInitialize(hWnd, dwWidth, dwHeight);
		break;

	case WINGLIDE_MODE_OVERLAY:
		bRet = OvlWGInitialize(hWnd, dwWidth, dwHeight);
		break;

	case WINGLIDE_MODE_STRETCH_BLT:
		bRet = StretchBltWGInitialize(hWnd, dwWidth, dwHeight);
		break;

	//B2 WinGlide is the default mode
	case WINGLIDE_MODE_B2:
	default:
		bRet = B2WGInitialize(hWnd, dwWidth, dwHeight);
	}

	//Return FALSE if initialization failed
	if (bRet == FALSE) {
		return bRet;
	}


	//Always do this here since it is safe to do
	//Reset gamma dialog exchange data
	ResetGammaDialogExchangeData();


	return bRet;
}

VOID CWGShutdown(VOID) {
	//Always do this here since it is safe to do
	//Destroy the gamma correction dialog or make sure it is not active
	DestroyWinGlideGammaDialog();

	//See which mode WinGlide is in
	switch (gdwWinGlideMode) {
	case WINGLIDE_MODE_OFF_SCREEN_SURFACE:
		OssWGShutdown();
		break;

	case WINGLIDE_MODE_OVERLAY:
		OvlWGShutdown();
		break;

	case WINGLIDE_MODE_STRETCH_BLT:
		StretchBltWGShutdown();
		break;

	//B2 WinGlide is the default mode
	case WINGLIDE_MODE_B2:
	default:
		B2WGShutdown();
	}

	return;
}


VOID CWGCopy3DfxFrameBuffer(VOID) {
	//See which mode WinGlide is in
	switch (gdwWinGlideMode) {
	case WINGLIDE_MODE_OFF_SCREEN_SURFACE:
		OssWGCopy3DfxFrameBuffer();
		break;

	case WINGLIDE_MODE_OVERLAY:
		OvlWGCopy3DfxFrameBuffer();
		break;

	case WINGLIDE_MODE_STRETCH_BLT:
		StretchBltWGCopy3DfxFrameBuffer();
		break;

	//B2 WinGlide is the default mode
	case WINGLIDE_MODE_B2:
	default:
		B2WGCopy3DfxFrameBuffer();
	}

	return;
}

FxBool CWGControl(FxU32 code) {
	//Voodoo
	switch (code) {
	case GR_CONTROL_ACTIVATE:
	case GR_CONTROL_DEACTIVATE:
	case GR_CONTROL_RESIZE:
	case GR_CONTROL_MOVE:
		return FXTRUE;
	default:
		return FXFALSE;
	}
}
